## 📜 توضیحات پروژه

**CrashBetEngine** یه اسکریپت حرفه‌ای و سبک برای راه‌اندازی سایت بت و کازینو آنلاین با بازی کرش (انفجار) هست. این اسکریپت به مدیرای سایت کمک می‌کنه یه پلتفرم بازی آنلاین پیشرفته با قابلیت کنترل کامل روی ضرایب، راند‌ها، و تراکنش‌ها راه‌اندازی کنن و درآمد بالایی داشته باشن. نسخه دمو برای تست اولیه ارائه شده و امکانات کامل تو نسخه پولی در دسترسه.

---

## ✨ ویژگی‌ها

- **مدیریت راند‌ها و ضرایب به سه روش**:
  - **خودکار**: تولید امن و تصادفی ضرایب و MD5 برای جلب اعتماد کاربرا.
  - **دستی**: تنظیم دلخواه ضرایب و راند‌ها برای کنترل سودآوری سایت.
  - **ثابت**: اجرای بازی با تنظیمات ثابت برای مدیریت ریسک و پایداری.
- **مدیریت حرفه‌ای**: کنترل کامل روی راند‌ها، کاربران، و تراکنش‌ها از طریق فایل‌های JSON.
- **سرعت بالا**: پردازش سریع و بدون لگ برای تجربه‌ای روان برای کاربرا.
- **سازگاری گسترده**: قابل اجرا روی انواع هاست و سرور برای نصب سریع.
- **نسخه دمو**: تست اولیه با اطلاعات پیش‌فرض و ساختگی برای ارزیابی.

---

## 🛠️ آموزش نصب نسخه دمو

نصب نسخه دمو خیلی ساده‌ست و نیازی به تنظیمات پیچیده نداره:

1. فایل زیپ پروژه رو از GitHub دانلود کنین.
2. فایل رو از حالت زیپ خارج کنین.
3. فایل `index.html` رو تو یه مرورگر مدرن (مثل کروم یا فایرفاکس) باز کنین.
4. اتصال WebSocket Secure (WSS) به صورت خودکار کارشو انجام می‌ده و می‌تونی نسخه دمو رو تست کنی.

---

## 📋 پیش‌نیازها

- یه مرورگر مدرن (مثل کروم، فایرفاکس) برای نسخه دمو.
- برای نسخه پولی: یه سرور با پشتیبانی از Node.js و WebSocket Secure (WSS).
- هاست یا سرور برای میزبانی اسکریپت کامل.

---

## 🚀 نحوه استفاده

- **نسخه دمو**: بعد از اجرای `index.html`، می‌تونی یه پیش‌نمایش از بازی کرش رو ببینی. اطلاعات MD5 و ضرایب ساختگی هستن و فقط برای تست طراحی شدن.
- **نسخه پولی**: برای راه‌اندازی یه سایت بت حرفه‌ای با امکانات کامل، نسخه پولی رو خریداری کنین و از فایل‌های کانفیگ برای تنظیم سرور استفاده کنین.

---

## 💡 نسخه دمو و دعوت به خرید

📢 **توجه**: این نسخه دمو هست و اطلاعاتش (مثل MD5 و ضرایب) ساختگیه. برای دسترسی به امکانات کامل، مثل تعداد کاربران نامحدود، پشتیبانی فنی، چت آنلاین، درگاه پرداخت، سیستم آنتی‌چیت، و حذف لوگو، باید نسخه پولی رو خریداری کنین.

برای خرید نسخه پولی و اطلاعات بیشتر، به آیدی تلگرام زیر پیام بدین:  
📩 [@AdminTahaSite](https://t.me/tahasite_admin)

---

## 📸 تصاویر پروژه
### تصویر کاور
![تصویر کاور](https://s6.uupload.ir/files/screencapture-127-0-0-1-5500-test-html-2025-03-12-00_44_21_zlte.png)

### مقایسه نسخه‌ها
![جدول مقایسه](https://s6.uupload.ir/files/screencapture-127-0-0-1-5500-test-html-2025-03-12-00_56_36_w6mt.png)

### محیط اسکریپت
![محیط اسکریپت](https://s6.uupload.ir/files/screencapture-localhost-classic-crash-2025-03-11-23_45_51_31yo.png)

---

## 📞 پشتیبانی و تماس

اگه سوال یا مشکلی داری، می‌تونی از طریق تلگرام با ما در تماس باشی:  
📩 [@tahasite_admin](https://t.me/tahasite_admin)

<img src="https://s6.uupload.ir/files/image_2025-03-12_01-27-52_3a5r.png" alt="QR Code for @AdminTahaSite" width="150" height="150">

---

## 📜 لایسنس (فارسی)

این پروژه تحت لایسنس نسخه دمو ارائه شده. اطلاعات بیشتر رو می‌تونی تو فایل [LICENSE](LICENSE) بخونی.

